﻿//NikDorn.com
using System.Collections;
using TMPro;
using UnityEngine;

public class TypingEffect : MonoBehaviour
{
    public float _typingSpeed = 0.1f;
    public bool _fadeIn = true;
    public bool _loop = false;
    public float _timeBL = 1;
    [SerializeField]  private string[] texts;

    private TMP_Text textMeshPro;
    private int textIndex = 0;

    void OnEnable()
    {
        textMeshPro = GetComponent<TMP_Text>();
        if (textMeshPro != null && texts.Length > 0)
        {
            textIndex = 0;
            textMeshPro.text = "";
            StartCoroutine(TypeText());
        }
    }

    IEnumerator TypeText()
    {
        while (true)
        {
            string currentText = texts[textIndex];

            for (int i = 0; i < currentText.Length; i++)
            {
                textMeshPro.text += currentText[i];

                if (_fadeIn)
                {
                    Color textColor = textMeshPro.color;
                    textColor.a = 0f;
                    textMeshPro.color = textColor;

                    // Fade in effect
                    while (textMeshPro.color.a < 1f)
                    {
                        textColor.a += 0.1f;
                        textMeshPro.color = textColor;
                        yield return new WaitForSeconds(_typingSpeed / 2);
                    }
                }

                yield return new WaitForSeconds(_typingSpeed);

                if (!_fadeIn && i == currentText.Length - 1)
                {
                    // If no fade-in
                    yield return new WaitForSeconds(1f);
                }
            }

            if (++textIndex >= texts.Length)
            {
                if (!_loop)
                    yield break; // Exit the coroutine if not looping

                yield return new WaitForSeconds(_timeBL);

                // Reset the text index
                textIndex = 0;
            }

            // Reset the text
            textMeshPro.text = "";
        }
    }
}
